

****************************************************************** 
********************** ANALYSIS ********************** 
****************************************************************** 
  
insheet using "mp_daily.csv", clear names

g year = substr(date,1,4)
g month = substr(date,6,2)
g day = substr(date,9,2)

destring year month day, replace

*****************
*IMPORTANT
drop if year < 2001
*Imposing this because NSI data are less reliable before this time 
*****************

gen d=mdy(month,day,year)
format %td d

g id = 1
tsset id d

merge 1:1 d using "crate_1980_2020.dta", nogen keep(match master)

*MP shocks...
merge m:1 month year using "mpshocks.dta", nogen keep(match master)

merge 1:1 day month year using "ois_shocks.dta", nogen keep(match master)


*Board meetings...
merge 1:1 d using "board_meetings.dta", nogen keep(match master)

replace board = 0 if board == .


merge 1:1 day month year using "asx_2001_2020.dta", nogen keep(match master)

merge 1:1 day month year using "releases.dta", nogen keep(match master)

replace cpi = 0 if cpi == .
replace gdp = 0 if gdp == .
replace lfs = 0 if lfs == .

gen dow = dow( mdy(month, day, year))

*Replacing weekends that have missing data
tsset id d 
replace asx = l1.asx if dow == 6
replace asx = l1.asx if dow == 0


*7 day window around economic releases
tsset id d 
foreach i in cpi gdp lfs {
g `i'_window = 0
replace `i'_window = 1 if `i' == 1
replace `i'_window = 1 if f1.`i'== 1
replace `i'_window = 1 if f2.`i' == 1
replace `i'_window = 1 if f3.`i' == 1
replace `i'_window = 1 if l1.`i' == 1
replace `i'_window = 1 if l2.`i' == 1
replace `i'_window = 1 if l3.`i' == 1
}


*Z scores
egen nsi_mean = mean(nsi)
egen nsi_sd = sd(nsi)
g znsi = (nsi-nsi_mean)/nsi_sd

egen mpnsi_mean = mean(mpnsi)
egen mpnsi_sd = sd(mpnsi)
g zmpnsi = (mpnsi-mpnsi_mean)/mpnsi_sd

egen asx_mean = mean(asx)
egen asx_sd = sd(asx)
g zasx = (asx-asx_mean)/asx_sd 


*Window of 14 days around policy announcement 
tsset id d
g window = 0 if board ==1
replace window = 1 if l1.board == 1
replace window = 2 if l2.board == 1
replace window = 3 if l3.board == 1
replace window = 4 if l4.board == 1
replace window = 5 if l5.board == 1
replace window = 6 if l6.board == 1
replace window = 7 if l7.board == 1
replace window = 8 if l8.board == 1
replace window = 9 if l9.board == 1
replace window = 10 if l10.board == 1
replace window = 11 if l11.board == 1
replace window = 12 if l12.board == 1
replace window = 13 if l13.board == 1
replace window = 14 if l14.board == 1


replace window = -1 if f1.board == 1
replace window = -2 if f2.board == 1
replace window = -3 if f3.board == 1
replace window = -4 if f4.board == 1
replace window = -5 if f5.board == 1
replace window = -6 if f6.board == 1
replace window = -7 if f7.board == 1
replace window = -8 if f8.board == 1
replace window = -9 if f9.board == 1
replace window = -10 if f10.board == 1
replace window = -11 if f11.board == 1
replace window = -12 if f12.board == 1
replace window = -13 if f13.board == 1
replace window = -14 if f14.board == 1

g period = (window ~=.)
g period2 = (window < 8 & window > -8)


*Daily changes 
g dcrate = d.crate
g dnsi = d.nsi
g dmpnsi = d.mpnsi 
reg dnsi dcrate


bysort month year: egen ois1m = max(ois_1m)
*No obvious month or year effects 

*Daily change in rates on policy decision days
g decrease = (dcr <0)
g increase = (dcr >0 & dcr ~=.)
g nochange = (dcrate ==0)
replace nochange = 0 if board == 0

*Type of interest rate change during the month 
bysort year month: egen increase_max = max(increase)
bysort year month: egen decrease_max = max(decrease)
bysort year month: egen nochange_max = max(nochange)


*Windows around increasing rates
preserve
keep if increase_max == 1
collapse(mean) dcrate nsi dnsi dmpnsi mpnsi znsi ois_1m, by(window)
drop if window > 10
drop if window < -10
 twoway (line nsi window) (line mpnsi window)
 twoway (line ois_1m window) (line dcrate window)
outsheet using "nsi_window_increase.csv", comma replace
restore

*Windows around decreasing rates
preserve
keep if decrease_max == 1
collapse(mean) dcrate nsi dnsi dmpnsi mpnsi znsi ois_1m, by(window)
drop if window > 10
drop if window < -10
 twoway (line nsi window) (line mpnsi window)  
 twoway (line ois_1m window) (line dcrate window)
outsheet using "nsi_window_decrease.csv", comma replace
restore

*Windows around no change
preserve
keep if nochange_max == 1
collapse(mean) dcrate nsi dnsi dmpnsi mpnsi znsi ois_1m, by(window)
drop if window > 10
drop if window < -10
twoway (line nsi window)
 twoway (line ois_1m window) (line dcrate window)
outsheet using "nsi_window_nochange.csv", comma replace

restore


*KEY VARIABLES...
tsset id d

*3-day MA 
g nsi_ma = (nsi+l1.nsi+l2.nsi)/3
g znsi_ma = (znsi+l1.znsi+l2.znsi)/3
g zmpnsi_ma = (zmpnsi+l1.zmpnsi+l2.zmpnsi)/3

g zasx_ma = (zasx+l1.zasx+l2.zasx)/3


*Setting baseline 
*THIS IS VERY IMPORTANT
*The baseline definitely should not update with the horizon 
*This sets the baseline as the 3-day MA on the day before the announcement 

g pnsi = nsi_ma  if window == -1 
g pznsi = znsi_ma  if window == -1 
g pzmpnsi = zmpnsi_ma  if window == -1 
g pzasx = zasx  if window == -1 


foreach i in pnsi pznsi pzmpnsi pzasx {
replace `i' = l1.`i' if window == 0
replace `i'= l1.`i' if window == 1
replace `i'= l1.`i' if window == 2
replace `i'= l1.`i' if window == 3
replace `i'= l1.`i' if window == 4
replace `i'= l1.`i' if window == 5
replace `i'= l1.`i' if window == 6
replace `i'= l1.`i' if window == 7
replace `i'= l1.`i' if window == 8
replace `i'= l1.`i' if window == 9
replace `i'= l1.`i' if window == 10
replace `i'= l1.`i' if window == 11
replace `i'= l1.`i' if window == 12
replace `i'= l1.`i' if window == 13
replace `i'= l1.`i' if window == 14
}


tsset id d

forvalues i = 0/14{
qui g d`i'nsi = f`i'.nsi - pnsi 
qui g d`i'znsi = f`i'.znsi - pznsi 
qui g d`i'zmpnsi = f`i'.zmpnsi - pzmpnsi 
qui g d`i'zasx = f`i'.zasx - pzasx 
}



g counter = .
g b_bishop = .
g se_bishop = .
g b_btcs = .
g se_btcs = .
g b_ois1 = .
g se_ois1 = .

g b_crate = .
g se_crate = .

g ci5_bishop = .
g ci95_bishop = .
g ci5_btcs =.
g ci95_btcs =.
g ci5_ois =.
g ci95_ois =.
g ci5_crate =.
g ci95_crate =.

g ci10_bishop = .
g ci90_bishop = .
g ci10_btcs =.
g ci90_btcs =.
g ci10_ois =.
g ci90_ois =.
g ci10_crate =.
g ci90_crate =.

*The results are robust to including lags...
tsset id d 

preserve
forvalues i = 0/10{
reg d`i'znsi bishop zasx if window == `i', robust level(90)
eststo ols_bishop`i'
	replace counter = `i' if _n == `i'+1
	replace b_bishop = _b[bishop] if _n == `i'+1
	replace se_bishop = _se[bishop] if _n == `i'+1
	replace ci10_bishop = _b[bishop] - invttail(e(df_r),0.05) * _se[bishop] if _n == `i'+1
 	replace ci90_bishop = _b[bishop] + invttail(e(df_r),0.05) * _se[bishop] if _n == `i'+1
 }
	keep counter b_* se_* ci10_* ci90_* 
	drop if counter == .
outsheet using "nsi_bishop.csv", comma replace
restore

preserve
forvalues i = 0/10{
reg d`i'znsi btcs  if window == `i', robust level(90)
eststo ols_btcs`i'
	replace counter = `i' if _n == `i'+1
	replace b_btcs = _b[btcs] if _n == `i'+1
	replace se_btcs= _se[btcs] if _n == `i'+1
	replace ci10_btcs = _b[btcs] - invttail(e(df_r),0.05) * _se[btcs] if _n == `i'+1
 	replace ci90_btcs = _b[btcs] + invttail(e(df_r),0.05) * _se[btcs] if _n == `i'+1
}
	keep counter b_* se_* ci10_* ci90_* 
	drop if counter == .
outsheet using "nsi_btcs.csv", comma replace

restore


preserve
forvalues i = 0/10{
reg d`i'znsi ois1m if window == `i', robust level(90)
eststo ols_ois1m`i'
	replace counter = `i' if _n == `i'+1
	replace b_ois = _b[ois] if _n == `i'+1
	replace se_ois = _se[ois] if _n == `i'+1
	replace ci10_ois = _b[ois] - invttail(e(df_r),0.05) * _se[ois] if _n == `i'+1
 	replace ci90_ois = _b[ois] + invttail(e(df_r),0.05) * _se[ois] if _n == `i'+1
}
	keep counter b_* se_* ci10_* ci90_* 
	drop if counter == .
outsheet using "nsi_ois1m.csv", comma replace
restore


******************
*CASH RATE CHANGES
******************
preserve
forvalues i = 0/10{
reg d`i'znsi cratechange if window == `i', robust level(90)
eststo ols_crate`i'
	replace counter = `i' if _n == `i'+1
	replace b_crate = _b[cratechange] if _n == `i'+1
	replace se_crate = _se[cratechange] if _n == `i'+1
	replace ci10_crate = _b[cratechange] - invttail(e(df_r),0.05) * _se[cratechange] if _n == `i'+1
 	replace ci90_crate = _b[cratechange] + invttail(e(df_r),0.05) * _se[cratechange] if _n == `i'+1
}
	keep counter b_* se_* ci10_* ci90_* 
	drop if counter == .
outsheet using "nsi_crate.csv", comma replace
restore


*PLACEBO TESTS

g pznsi_placebo = pznsi 
gsort id -d 
replace pznsi_placebo = pznsi_placebo[_n-1] if window == -2
replace pznsi_placebo = pznsi_placebo[_n-1] if window == -3

tsset id d

g l1znsi = L1.znsi - pznsi_placebo
g l2znsi = L2.znsi - pznsi_placebo
g l3znsi = L3.znsi - pznsi_placebo
  
reg l1znsi bishop  if window == -1, robust level(90)
reg l2znsi bishop  if window == -2, robust level(90)
reg l3znsi bishop  if window == -3, robust level(90)

reg l1znsi btcs if window == -1, robust level(90)
reg l2znsi btcs if window == -2, robust level(90)
reg l3znsi btcs if window == -3, robust level(90)

reg l1znsi ois1m if window == -1, robust level(90)
reg l2znsi ois1m if window == -2, robust level(90)
reg l3znsi ois1m if window == -3, robust level(90)

